--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Moscow
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "mos_marketkeep" }
DefineCharacter { name = "mos_shopkeep" }
DefineCharacter { name = "mos_barkeep" }
DefineCharacter { name = "mos_otherkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "moscow",
	available = false,
	ambient = "sfx/metropolitan_loop.ogg",

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_02", time=170000, loop=true, htile=true, path={{0,50},{100,50},{700,50},{800,50}}, },
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.25,hold=12000,
			path={{-49,25},{38,98},{515,-15},{848,99},},},
			
			
--		EmptyBuilding { name="image="mos_gate", ambient="sfx/other_loop.ogg", x=204+206/2,y=38+258/2 },
		GenericBuilding { name="mos_gate", character="mos_barkeep", ambient="sfx/other_loop.ogg", x=204+206/2,y=38+258/2 },

		EmptyBuilding { name="mos_basil", ambient="sfx/other_loop.ogg", x=639+161/2,y=6+240/2, labelx=740,labely=126},
		
		-- Rear Horizontal Cars
		SpriteLayer { imagelist=portCars, scale=.3, time=16000,hold=3000,bounce=true,
			path={{-83,288},{176,273},{248,304},{302,297},{359,284},{432,281},{598,284},},},
		SpriteLayer { imagelist=portCars, scale=.3, time=13000,hold=5000,bounce=true,
			path={{-83,290},{176,275},{248,306},{302,299},{359,286},{432,283},{598,286},},},
		
		-- Other perspective cars
		SpriteLayer { image="car_07", scale=.4,hold=1000,time=11000,
			path={{383,564},{320,423},{253,316},{213,289},},},
		SpriteLayer { image="car_12", scale=.4,time=9000,
			path={{223,289},{302,313},{342,432},{418,560},},},
		SpriteLayer { image="car_07", scale=.4,hold=2000,time=8000,
			path={{575,524},{420,387},{351,306},{404,279},},},
		SpriteLayer { image="car_12", scale=.4,time=12000,
			path={{360,294},{415,324},{540,401},{625,456},},},
		
		SpriteLayer { image="mos_carmask", x=0+241/2,y=278+38/2 },
		
		Shop { name="mos_shop", character="mos_shopkeep", x=404+275/2,y=125+240/2, labelx=435,labely=200 },
		Market { name="mos_market", character="mos_marketkeep", x=506+160/2,y=211+168/2, labelx=545, labely=270,
			inventory = { sugar=true, } },
			
		EmptyBuilding { name="mos_other", character={"mos_otherkeep"}, x=23+167/2,y=267+104/2 },
		SpriteLayer { image="mos_stationmask", ambient="sfx/other_loop.ogg", x=3+205/2,y=303+88/2 },

		-- Mid Horizontal Cars
		SpriteLayer { imagelist=portCars, scale=.50,hold=2000,bounce=true,
			path={{-86,422},{435,406},{546,386},{883,341},},},
			
		SpriteLayer { imagelist=portCars, scale=.50,hold=3000,
			path={{-82,425},{416,421},{544,392},{883,341},},},

		EmptyBuilding { name="mos_zuev", ambient="sfx/saloon_loop.ogg", x=610+190/2,y=199+196/2, labelx=670,labely=320 },
		-- invisible below UI
--		SpriteLayer { image="mos_zuevmask", x=584+216/2,y=403+93/2 },
	}
}
